#!/bin/sh

# /*******************************************************************************/
# /*                                                                             */
# /*  Copyright 2004 Pascal Gloor                                                */
# /*                                                                             */
# /*  Licensed under the Apache License, Version 2.0 (the "License");            */
# /*  you may not use this file except in compliance with the License.           */
# /*  You may obtain a copy of the License at                                    */
# /*                                                                             */
# /*     http://www.apache.org/licenses/LICENSE-2.0                              */
# /*                                                                             */
# /*  Unless required by applicable law or agreed to in writing, software        */
# /*  distributed under the License is distributed on an "AS IS" BASIS,          */
# /*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   */
# /*  See the License for the specific language governing permissions and        */
# /*  limitations under the License.                                             */
# /*                                                                             */
# /*******************************************************************************/



progs="grep awk sed cp mkdir chmod printf";

tab_print()
{
	first=1;

	for name in $2
	do
		if [ "$first" -eq "1" ]
		then
			printf "%-9s : %s\n" $1 $name
		else
			printf "            %s\n" $name
		
		fi

		first=0;
	done
}

addpath()
{
	if [ -r "${1}.in" ]
	then
		MYPATH=`echo ${DIR} | sed "s/\//\\\\\\\\\\//g"`;
		cat ${1}.in | sed "s/\%PATH\%/${MYPATH}/g" > ${1};
	else
		echo "error cannot read ${1}.in";
		exit 1;
	fi
}

create_dir()
{
	printf "creating directory ";
	if [ -r "${1}" ]
	then
		if [ -d "${1}" ]
		then
			echo "${1} ok (exists)";
		else
			echo "${1} exist and is NOT a directory, sorry.";
			exit 1;
		fi
	else
		mkdir -p ${1};
		if [ "$?" != 0 ]
		then
			echo "error creating ${1}, sorry.";
			exit 1;
		fi
		echo "${1} ok (created)";
	fi
}

copy_file()
{
	printf "installing %s (mode %s)\n" ${2} ${3}

	cp -f ${1} ${2};
	if [ "$?" != 0 ]; then echo "error copying file, sorry"; exit 1; fi

	chmod ${3} ${2};
	if [ "$?" != 0 ]; then echo "error changing file mode, sorry"; exit 1; fi
}

locate_prog()
{
	LOC=`which ${1} 2>&1`;
	if [ ! -x "${LOC}" ]
	then
		echo "looking for ${1}... not found ;(";
		echo "Please check your PATH environement variable";
		exit 1;
	fi
}

for myprog in $progs
do
	locate_prog $myprog
done

P_VER_MA=`grep P_VER_MA include/p_defs.h | awk '{print $3}' | sed "s/\"//g" `;
P_VER_MI=`grep P_VER_MI include/p_defs.h | awk '{print $3}' | sed "s/\"//g" `;
P_VER_PL=`grep P_VER_PL include/p_defs.h | awk '{print $3}' | sed "s/\"//g" `;

if [ -z "$1" ]; then
	echo "Piranha v${P_VER_MA}.${P_VER_MI}.${P_VER_PL} BGP Daemon, compilation/installtion script.";
	echo ""
	echo "syntax: $0 <directory> [debug]";
	echo ""
	echo "directory : the place where you want to install Piranha,";
	echo "            /usr/local/piranha sounds a good place.";
	echo "debug     : optional"
	echo "";
	exit 1;
fi

if [ -n "$2" ]; then DODEBUG=1; fi

DIR=`echo $1 | sed "s/\/$//" | sed "s/\/\//\//g"`;

echo "
/*******************************************************************************/
/*                       ___  _               __                               */
/*                      / _ \(_)______ ____  / /  ___ _                        */
/*                     / ___/ / __/ _ \`/ _ \/ _ \/ _ \`/                        */
/*                    /_/  /_/_/  \_,_/_//_/_//_/\_,_/                         */
/*                                                                             */
/*******************************************************************************/
/*                                                                             */
/*  Copyright 2004 Pascal Gloor                                                */
/*                                                                             */
/*  Licensed under the Apache License, Version 2.0 (the \"License\");            */
/*  you may not use this file except in compliance with the License.           */
/*  You may obtain a copy of the License at                                    */
/*                                                                             */
/*     http://www.apache.org/licenses/LICENSE-2.0                              */
/*                                                                             */
/*  Unless required by applicable law or agreed to in writing, software        */
/*  distributed under the License is distributed on an \"AS IS\" BASIS,          */
/*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   */
/*  See the License for the specific language governing permissions and        */
/*  limitations under the License.                                             */
/*                                                                             */
/*******************************************************************************/
"
echo "(dont be scared, just a common open source license)";
printf "Do you accept the above license ? ([Y]/n) "
read test
echo ""

if [ -z "$test" ]; then test="Y"; fi;

case "$test" in

[y]|[Y])
	;;

*)
	echo ""
	echo "so bad, you have to accept the license to continue..."
	exit 1;
	;;
esac

echo ""
echo ""

OS=`uname -s | tr [a-z] [A-Z]`
OSVER=`uname -r`

if [ -z "$OS" ]
then
	echo "ERROR: unable to determine Operating System. Sorry"
	exit 1
fi


if [ -x "`which gcc 2>&1`" ]
then
	cc="gcc";
	CC="GCC";
	debug="-g -DDEBUG";

	if [ "$OS" = "FREEBSD" ]
	then
		warn="-Wall -Wshadow -Wcast-qual -Wcast-align -Wpointer-arith -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations -Wredundant-decls -Wnested-externs -Werror";
		opt="-O2 -ansi -pedantic -fsigned-char";
		lib="-pthread -D_THREAD_SAFE";
	elif [ "$OS" = "NETBSD" ]
	then
		warn="-Wall -Wshadow -Wcast-qual -Wcast-align -Wpointer-arith -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations -Wredundant-decls -Wnested-externs -Werror";
		opt="-O2 -ansi -pedantic -fsigned-char";
		lib="-lpthread";
	elif [ "$OS" = "LINUX" ]
	then
		warn="-Wall -Wshadow -Wcast-qual -Wcast-align -Wpointer-arith -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Werror";
		lib="-lpthread";
		opt="-O2 -fsigned-char";
	elif [ "$OS" = "DARWIN" ]
	then
		warn="-Wall -Wshadow -Wcast-qual -Wcast-align -Wpointer-arith -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Werror";
#		lib="-lpthread";
		opt="-O2 -fsigned-char";
	else
		echo "WARNING: You're running a funky OS (${OS} ${OSVER}). The compilation might not work.";
		warn="-Wall"
		opt="-O2 -ansi -pedantic -fsigned-char";
		lib="-lpthread";
	fi

elif [ -x "`which cc 2>&1`" ]
then
	echo "WARNING: You're running a funky compiler on a funky OS (${OS} ${OSVER}).";
	echo "we're not yet compatible with your OS";
	echo "feel free to contact us to make it compatible with your platform.";
	echo "mailto: <piranha@spale.com>";
	exit 1;
else

	echo "ERROR: No C compiler found. Sorry."
	exit 1;
fi

if [ -z "$DODEBUG" ]; then debug=""; fi

echo "compiler and options we'll use :"
echo ""
echo "system    : $OS $OSVER"
echo "compiler  : $cc";
tab_print "options" "$opt"
tab_print "warnings" "$warn"
tab_print "libraries" "$lib"

if [ -n "${DODEBUG}" ]
then
	echo "debug     -> $debug";
fi

echo ""


incdir="-Iinclude"
libdir=""
srcdir="src"
objdir="obj"
src1="p_config p_socket p_log p_dump p_piranha"
prog1="bin/piranha"
src2="p_ptoa"
prog2="bin/ptoa"
tmp1=""
tmp2=""

opt="$opt -D${OS} -D${CC}";


for compile in $src1
do
	if [ -n "${DODEBUG}" ]
	then
		echo "$cc $debug -DPATH=\"${DIR}\" $libdir $incdir $opt $warn -o $objdir/$compile.o -c $srcdir/$compile.c";
	else
		printf "compiling %-15s   ->   %-15s ... " $srcdir/$compile.c $objdir/$compile.o
	fi
	
	$cc $debug -DPATH=\"${DIR}\" $libdir $incdir $opt $warn -o $objdir/$compile.o -c $srcdir/$compile.c

	if [ "$?" -ne "0" ]
	then
		echo "ERROR: compilation error"
		exit 1;
	else
		echo "ok";
	fi

	tmp1="$tmp1 $objdir/$compile.o"
done

for compile in $src2
do
	if [ -n "${DODEBUG}" ]
	then
		echo "$cc $debug -DPATH=\"${DIR}\" $libdir $incdir $opt $warn -o $objdir/$compile.o -c $srcdir/$compile.c";
	else
		printf "compiling %-15s   ->   %-15s ... " $srcdir/$compile.c $objdir/$compile.o
	fi
	
	$cc $debug $libdir $incdir $opt $warn -o $objdir/$compile.o -c $srcdir/$compile.c

	if [ "$?" -ne "0" ]
	then
		echo "ERROR: compilation error"
		exit 1;
	else
		echo "ok";
	fi

	tmp2="$tmp2 $objdir/$compile.o"
done

if [ -n "${DODEBUG}" ]
then
	echo "$cc $debug $libdir $incdir $lib $warn -o $prog1 $tmp1";
	echo "$cc $debug $libdir $incdir $lib $warn -o $prog2 $tmp2";
else
	echo "";
	tab_print "linking" "$tmp1 [$prog1]"
	echo "";
	tab_print "linking" "$tmp2 [$prog2]"
fi

$cc $debug $libdir $incdir $lib $warn -o $prog1 $tmp1
$cc $debug $libdir $incdir $lib $warn -o $prog2 $tmp2

if [ "$?" -ne "0" ]
then
	echo "ERROR: linking error"
	exit 1;
else
	echo "ok";
fi

echo ""
echo "compilation done ;-)"
echo ""

printf "Install Piranha to ${DIR} ? ([Y]/n) "
read test

if [ -z "$test" ]; then test="Y"; fi;

case "$test" in

[Y]|[y])
	;;
*)
	echo "restart \"$0\" at any time to finish the installation.";
	echo "installation aborted";
	exit 1;
	;;
esac

echo "";

create_dir "${DIR}/bin";
create_dir "${DIR}/etc";
create_dir "${DIR}/var";
create_dir "${DIR}/dump";
create_dir "${DIR}/man/man1";
create_dir "${DIR}/man/man5";

echo ""

addpath "./utils/piranhactl";

copy_file ./$prog1 ${DIR}/$prog1 555
copy_file ./$prog2 ${DIR}/$prog2 555

if [ -r "${DIR}/etc/piranha.conf" ]
then
	echo "WARNING: ${DIR}/etc/piranha.conf already exist. will not be overwritten.";
else
	copy_file ./etc/piranha.conf ${DIR}/etc/piranha.conf 644
fi

copy_file ./utils/piranhactl ${DIR}/bin/piranhactl 555

copy_file ./man/man1/piranha.1 ${DIR}/man/man1/piranha.1 444
copy_file ./man/man1/piranhactl.1 ${DIR}/man/man1/piranhactl.1 444
copy_file ./man/man1/ptoa.1 ${DIR}/man/man1/ptoa.1 444
copy_file ./man/man5/piranha.conf.5 ${DIR}/man/man5/piranha.conf.5 444

echo "/-----------------------------------------------------------------";
echo "|";
echo "| Piranha has been installed to ${DIR}";
echo "|";
echo "| start: ${DIR}/bin/piranhactl start";
echo "|";
echo "| Please read the doc/piranha.txt file and the sample configuration";
echo "| (${DIR}/etc/piranha_sample.conf)";
echo "|";
echo "| manpages available!";
echo "| man -M${DIR}/man piranha";
echo "| man -M${DIR}/man piranha.conf";
echo "| man -M${DIR}/man piranhactl";
echo "| man -M${DIR}/man ptoa";
echo "|";
echo "\\------------------------------------------------------------------";
